
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Nov 30 10:17:10 2008
   *  Last modified   :  %modify_time%
   */
  /** @file 
      *  \brief This file includes the RND ATP tests
   *
   *  \version CRYS_SEP_ATP_RND_Acceptance.c#1:csrc:1
   *  \author 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "CRYS.h"
#include "CRYS_RND.h"
//#include "CRYS_SEP_ATP_Defines.h"
//#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_SEP_ATP_RND_Acceptance.h"
#include "DX_VOS_Mem.h"


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

extern CRYSError_t      TST_ATP_Error;
/************* Private function prototype ***********************/
/************************ Public Functions ******************************/
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   char        *FailureFunctionNameOut_ptr);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_No_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Random API's 
*  Random vector size - 750
* Algorithm:       
* 1. Call the CRYS_RND_GenerateVector function to generate a random value
* 2. Call the CRYS_RND_GenerateVector to generate a random second random value
* 3. Compare the random numbers and verify the are different                                               
*
**************************************************************************************/                                
CRYSError_t SEPQA_RND_No_Reset(DxUint16_t	RNDSize,
							   DxUint8_t   *FailureFunctionNameOut_ptr)
{
	/*** TST Variables Definitions ****/
	CRYSError_t             TST_TestStatus=0;
	TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};  

	/* 1. Generate first random value */
	/*******************************/
	TST_ATP_Error = CRYS_RND_GenerateVector(RNDSize,TST_RND_Results.TST_RND_Output1);

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
		"CRYS_RND_GenerateVector - TST_RND_Output1",
		FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;

	/* 2. Generate Second random value */
	/***********************************/    
	TST_ATP_Error = CRYS_RND_GenerateVector(RNDSize,TST_RND_Results.TST_RND_Output2);

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
		"CRYS_RND_GenerateVector - TST_RND_Output2",
		FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;

	/* 3. Compare the random numbers and verify the are different */
	/***********************************************************/     
	TST_ATP_Error = (CRYSError_t)DX_VOS_MemCmp(TST_RND_Results.TST_RND_Output1,
		TST_RND_Results.TST_RND_Output2 ,
		RNDSize);	                                                                   

End:
	return TST_ATP_Error;	

}

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RND_Reset         
* 
* Inputs:
* RNDSize - size of random vector to generate
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for Random API's 
*  Random vector size - 750
* Algorithm:       
* 1. Call the CRYS_RND_GenerateVector function to generate a random value
* 2. Call the CRYS_RND_GenerateVector to generate a random second random value
* 3. Compare the random numbers and verify the are different                                               
*
**************************************************************************************/                                
CRYSError_t SEPQA_RND_Reset(DxUint16_t	RNDSize,
							DxUint8_t   *FailureFunctionNameOut_ptr)
{
	/*** TST Variables Definitions ****/
	CRYSError_t             TST_TestStatus=0;
	TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};  

	/* 1. Reset the random seed */
	/****************************/
	TST_ATP_Error = CRYS_RND_ResetSeed();

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
												"CRYS_RND_ResetSeed",
												FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;

	/* 2. Generate first random value */
	/**********************************/
	TST_ATP_Error = CRYS_RND_GenerateVector(RNDSize,TST_RND_Results.TST_RND_Output1);

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
												"CRYS_RND_GenerateVector",
												FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;	

	
	/* 3. Reset the random seed */
	/****************************/
	TST_ATP_Error = CRYS_RND_ResetSeed();

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
		"CRYS_RND_ResetSeed",
		FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;	
	
	/* 4. Generate Second random value */
	/***********************************/      
	TST_ATP_Error = CRYS_RND_GenerateVector(RNDSize,TST_RND_Results.TST_RND_Output2);

	TST_TestStatus = SEPQA_ATP_CheckErrorReturn(TST_ATP_Error,
		"CRYS_RND_GenerateVector",
		FailureFunctionNameOut_ptr);

	if (TST_TestStatus != TESTPASS) 
		goto End;	


	/* Compare the Random Values */
	/*****************************/     
	TST_ATP_Error = (CRYSError_t)DX_VOS_MemCmp(TST_RND_Results.TST_RND_Output1,
											   TST_RND_Results.TST_RND_Output2 ,
											   RNDSize);

End:
	return TST_ATP_Error;	
}












